<?php
// logout.php (with confirmation)
require_once 'config.php';

// Check if this is a confirmation request
if (isset($_GET['confirm']) && $_GET['confirm'] === 'true') {
    // User confirmed logout - proceed with logout
    
    // Clear all session variables
    $_SESSION = array();

    // Delete the session cookie
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(
            session_name(), 
            '', 
            time() - 42000,
            $params["path"], 
            $params["domain"], 
            $params["secure"], 
            $params["httponly"]
        );
    }

    // Destroy the session
    session_destroy();

    // Redirect to login page
    header("Location: login.php?message=" . urlencode("You have been logged out successfully."));
    exit;
} else {
    // Show logout confirmation page
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Logout Confirmation - VPS Manager</title>
        <style>
            body { 
                font-family: Arial, sans-serif; 
                max-width: 400px; 
                margin: 50px auto; 
                padding: 20px; 
                text-align: center;
            }
            .confirmation-box {
                background: #f8f9fa;
                padding: 30px;
                border-radius: 8px;
                border: 1px solid #dee2e6;
            }
            .btn { 
                display: inline-block; 
                padding: 10px 20px; 
                margin: 10px;
                border: none; 
                border-radius: 4px; 
                cursor: pointer; 
                text-decoration: none; 
                font-size: 16px;
            }
            .btn-confirm { 
                background: #dc3545; 
                color: white; 
            }
            .btn-cancel { 
                background: #6c757d; 
                color: white; 
            }
            .btn:hover {
                opacity: 0.9;
            }
        </style>
    </head>
    <body>
        <div class="confirmation-box">
            <h2>Logout Confirmation</h2>
            <p>Are you sure you want to logout?</p>
            <p>You will need to login again to access your VPS instances.</p>
            
            <div>
                <a href="logout.php?confirm=true" class="btn btn-confirm">Yes, Logout</a>
                <a href="javascript:history.back()" class="btn btn-cancel">Cancel</a>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit;
}
?>